// js/register.js
import { supabase } from './supabase.js';

// Função para inicializar a página de cadastro de usuário
function initRegisterPage() {
    const registerForm = document.getElementById('register-user-form');
    const registerMessage = document.getElementById('register-message');

    if (!registerForm) return; // Garante que o script só execute se o formulário existir

    registerForm.addEventListener('submit', async (e) => {
        e.preventDefault();

        const username = document.getElementById('reg-username').value;
        const password = document.getElementById('reg-password').value;
        const profile = document.getElementById('reg-profile').value;
        const active = document.getElementById('reg-active').checked;

        if (!username || !password || !profile) {
            registerMessage.textContent = 'Por favor, preencha todos os campos obrigatórios.';
            registerMessage.style.color = 'var(--error-color)';
            return;
        }

        try {
            // Verificar se o usuário já existe
            const { data: existingUser, error: existingUserError } = await supabase
                .from('usuario')
                .select('id')
                .eq('username', username)
                .single();

            if (existingUserError && existingUserError.code !== 'PGRST116') { // PGRST116: Nenhum resultado encontrado
                throw existingUserError;
            }

            if (existingUser) {
                registerMessage.textContent = 'Este nome de usuário já existe. Por favor, escolha outro.';
                registerMessage.style.color = 'var(--error-color)';
                return;
            }

            // Inserir novo usuário
            const { data, error } = await supabase
                .from('usuario')
                .insert([
                    { username: username, senha: password, perfil: profile, ativo: active }
                ]);

            if (error) {
                throw error;
            }

            registerMessage.textContent = 'Usuário cadastrado com sucesso!';
            registerMessage.style.color = 'var(--success-color)';
            registerForm.reset(); // Limpa o formulário
            document.getElementById('reg-active').checked = true; // Reseta o toggle para 'ativo'
        } catch (error) {
            console.error('Erro ao cadastrar usuário:', error.message);
            registerMessage.textContent = `Erro ao cadastrar: ${error.message}`;
            registerMessage.style.color = 'var(--error-color)';
        }
    });
}

// Expõe a função para ser chamada pelo main.js quando a página for carregada via AJAX
window.initRegisterPage = initRegisterPage;
