// js/login.js
import { supabase } from './supabase.js';

document.addEventListener('DOMContentLoaded', () => {
    const loginForm = document.getElementById('login-form');
    const loginMessage = document.getElementById('login-message');
    const themeToggle = document.getElementById('theme-toggle');
    const themeIcon = themeToggle.querySelector('i');

    // Carrega o tema salvo no localStorage
    const savedTheme = localStorage.getItem('theme') || 'light-theme';
    document.body.className = savedTheme;
    themeIcon.className = savedTheme === 'light-theme' ? 'fas fa-sun' : 'fas fa-moon';

    // Alterna o tema e salva no localStorage
    themeToggle.addEventListener('click', () => {
        if (document.body.classList.contains('light-theme')) {
            document.body.classList.remove('light-theme');
            document.body.classList.add('dark-theme');
            themeIcon.className = 'fas fa-moon';
            localStorage.setItem('theme', 'dark-theme');
        } else {
            document.body.classList.remove('dark-theme');
            document.body.classList.add('light-theme');
            themeIcon.className = 'fas fa-sun';
            localStorage.setItem('theme', 'light-theme');
        }
    });

    // Lógica de submissão do formulário de login
    loginForm.addEventListener('submit', async (e) => {
        e.preventDefault();

        const username = document.getElementById('username').value;
        const password = document.getElementById('password').value;
        const profile = document.getElementById('profile').value;

        if (!username || !password || !profile) {
            loginMessage.textContent = 'Por favor, preencha todos os campos.';
            loginMessage.style.color = 'var(--error-color)';
            return;
        }

        try {
            // Busca o usuário na tabela 'usuario'
            const { data, error } = await supabase
                .from('usuario')
                .select('*')
                .eq('username', username)
                .eq('perfil', profile)
                .single(); // Espera apenas um resultado

            if (error && error.code === 'PGRST116') { // PGRST116: Nenhum resultado encontrado
                loginMessage.textContent = 'Usuário, senha ou perfil inválidos.';
                loginMessage.style.color = 'var(--error-color)';
                return;
            } else if (error) {
                // Outros erros do Supabase que não sejam 'nenhum resultado'
                throw error;
            }

            // Verifica se o usuário existe e se a senha está correta
            // ATENÇÃO: Em um ambiente real, a senha NUNCA deve ser armazenada em texto puro no banco.
            // Use bcrypt ou outra função de hash para comparar senhas de forma segura.
            if (data && data.senha === password) { // 'senha' é o nome da coluna no seu DB
                if (data.ativo) { // Verifica se o usuário está ativo
                    loginMessage.textContent = 'Login bem-sucedido!';
                    loginMessage.style.color = 'var(--success-color)';
                    // Salva informações do usuário na sessão (simulado)
                    sessionStorage.setItem('loggedInUser', JSON.stringify({
                        username: data.username,
                        perfil: data.perfil,
                        userId: data.id
                    }));
                    setTimeout(() => {
                        window.location.href = 'main.html'; // Redireciona para a página principal
                    }, 1000);
                } else {
                    loginMessage.textContent = 'Sua conta está inativa. Por favor, entre em contato com o administrador.';
                    loginMessage.style.color = 'var(--error-color)';
                }
            } else {
                loginMessage.textContent = 'Usuário, senha ou perfil inválidos.';
                loginMessage.style.color = 'var(--error-color)';
            }
        } catch (error) {
            console.error('Erro no login:', error.message);
            loginMessage.textContent = `Erro ao tentar fazer login: ${error.message}`;
            loginMessage.style.color = 'var(--error-color)';
        }
    });
});
